<?php defined('BASEPATH') || exit('No direct script access allowed.');

/**
* Question Resources
*/
class Question_Resources_Model extends CI_Model
{
	public $table = 'question_resource';
	public $resource_type = 'paragraph';

	function __construct()
	{
		parent::__construct();
	}

	public function insert()
	{
		$data = array(
			'resource_content_en' => $this->input->post('paragraph_en'),
			'resource_content_hin' => $this->input->post('paragraph_hin'),
			'resource_type' => $this->resource_type
		);

		if($this->db->insert($this->table, $data)){
			return $this->db->insert_id();
		}
		return false;
	}

	public function get($resource_id = NULL)
	{
		if($resource_id != NULL) {
			$query = $this->db->get_where($this->table,array('question_resource_ID'=>$resource_id,'resource_type'=>'paragraph'));
			return $query->row();
		}
		$this->db->order_by('question_resource_ID', 'DESC');
		$query = $this->db->get_where($this->table,array('resource_type'=>'paragraph'));
		return $query->result();
	}

	public function update($resource_id)
	{
		$data = array(
			'resource_content_en'	=> $this->input->post('paragraph_content_en'),
			'resource_content_hin'	=> $this->input->post('paragraph_content_hin')
		);

		$this->db->where('question_resource_ID',$resource_id);
		return $this->db->update($this->table, $data);
	}
}